/******************************************************************************
 * Technical University of Technology Darmstadt
 * Industrial Process and System Communication
 * Project:  TCP
 * Filename: TCPSynSent.java
  * Contents: Actions in State Syn_Sent of TCP-FSM
 *****************************************************************************/
import java.util.Vector;
import java.util.Date;

/******************************************************************************
* Class: TCPSynSent
* Description: acts corresponding the properties of incoming TCP-Segment
******************************************************************************/
public class TCPSynSent {

SegArrive parent;
SessionControlBlock newtcb;
int j;

public SessionControlBlock TCPSynSent( SegArrive home, SessionControlBlock newtcb, int j ) {

    this.parent = home;
    this.newtcb = newtcb;
    this.j = j;

    while(true) {
          if(parent.segment1.SYN == 1) {
              if(parent.segment1.ACK == 1) {
                newtcb.setack.setAck();
    	        newtcb.TcpStatus = 4;
    	        newtcb.RCVNXT = parent.segment1.Seqnumb+1;
                newtcb.IRS = parent.segment1.Seqnumb;
                newtcb.SNDUNA = parent.segment1.Acknumb;
       	        newtcb. retqueue.removeAllElements();
                //(" Server syn = ack = 1 ich bilde ein Ack ");
                TcpSegment s1 = new TcpSegment();
                int k = new SqNbGenerator().getISS(parent.time);
                s1.Lpnumb = parent.segment1.Dpnumb;
                newtcb.partnerresp = 0;
                s1.SYN = 0;
                s1.ACK = 1;
                s1.Dpnumb  = parent.segment1.Lpnumb;
                s1.Seqnumb = newtcb.SNDNXT;
                newtcb.Dpnumb = parent.segment1.Lpnumb;
                newtcb.RCVWND = parent.segment1.Wsize;
                newtcb.SNDNXT++;
                s1.Acknumb = parent.segment1.Seqnumb +1;
                s1.Hdlength = 5;
	            String s = "ESTABLISHED";
                s1.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
                s1 = new Checksum().build(s1);
	            parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(s1,true,new Date().getTime(),true,s));
                parent. tonet.putElement(s1);
                parent. fromnet.removeElementAt(0);
                break;
              }
              else {
                TcpSegment sg2 = new TcpSegment();
                newtcb.TcpStatus = 3;
                parent. tcppro.darfsenden.getrighttosend();
               	newtcb.RCVNXT = parent.segment1.Seqnumb+1;
                newtcb.IRS = parent.segment1.Seqnumb;
                newtcb.SNDUNA = parent.segment1.Acknumb;
                //System.out.println("Server syn =1, ack = 0;Ich bilde ein ack seg");
                sg2.Lpnumb = parent.segment1.Dpnumb;
                sg2.Dpnumb = parent.segment1.Lpnumb;
                sg2.Seqnumb =newtcb.SNDNXT;
                sg2.Acknumb = newtcb.RCVNXT;
    	        newtcb.RCVWND = parent.segment1.Wsize;
                sg2.SYN = 1;
                sg2.ACK = 1;
                sg2.Hdlength = 5;
	            String s = "SYN_RCVD";
                sg2.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
                sg2 = new Checksum().build(sg2);
                parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg2,true,new Date().getTime(),true,s));
    	        parent. tonet.putElement(sg2);
               	parent. fromnet.removeElementAt(0);
    	        parent. tcppro.darfsenden.giverighttosend();
               	Timeout t2 = new Timeout(parent.halt,parent.tcppro,3,parent.tcb,newtcb);
               	newtcb.SNDNXT++;
                break;
              }
            }
            else {
              if(parent.segment1.ACK == 1) {
                  if(parent.segment1.RST == 1){
                    parent. fromnet.removeElementAt(0);
                    break;
                  }
                  if((parent.segment1.Acknumb <= newtcb.ISS)|(parent.segment1.Acknumb > newtcb.SNDNXT)) {
                    TcpSegment sget = new TcpSegment();
                    //("Server ich bilde ein rst Segment");
                    sget.Lpnumb = parent.segment1.Dpnumb;
                    sget.RST = 1;
                    sget.Wsize =(short)(((SessionControlBlock)parent.tcb.elementAt(j)).toclientbuffer.capacity()-((SessionControlBlock)parent.tcb.elementAt(j)).toclientbuffer.size());
                    sget.Dpnumb  = parent.segment1.Lpnumb;
                    sget.Seqnumb = parent.segment1.Acknumb;
                    sget.Hdlength = 5;
	                String s = "SYN_SENT";
                    sget = new Checksum().build(sget);
                    //System.out.println("Server signaliert Client, dass kein Server horscht auf dem Port");
                    parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sget,true,new Date().getTime(),true,s));
                    parent. tonet.putElement(sget);
                    parent. fromnet.removeElementAt(0);
                    break;
                  }
              }
          }
          parent. fromnet.removeElementAt(0);

    } //END while(true)
    return newtcb;
} //END methode TCPSynSent
} //END class TCPSynSent
